<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Upload de Vídeo</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
        }
        .container {
            max-width: 600px;
            margin: 50px auto;
            padding: 20px;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }
        h2 {
            margin-top: 0;
            text-align: center;
        }
        form {
            text-align: center;
        }
        input[type="file"] {
            display: none;
        }
        .file-upload {
            display: inline-block;
            padding: 10px 20px;
            cursor: pointer;
            background-color: #007bff;
            color: #fff;
            border: none;
            border-radius: 4px;
            transition: background-color 0.3s;
        }
        .file-upload:hover {
            background-color: #0056b3;
        }
        input[type="submit"] {
            display: none;
        }
        .btn-submit {
            display: inline-block;
            padding: 10px 20px;
            background-color: #28a745;
            color: #fff;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        .btn-submit:hover {
            background-color: #218838;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Upload de Vídeo</h2>
        <form action="upload_video.php" method="post" enctype="multipart/form-data">
            <label for="videoFile" class="file-upload">Selecione um vídeo</label>
            <input type="file" name="videoFile" id="videoFile" onchange="enableUpload()">
            <input type="submit" value="Upload Vídeo" name="submit" class="btn-submit" id="uploadButton" style="display:none;">
        </form>
    </div>

    <script>
        function enableUpload() {
            document.getElementById("uploadButton").style.display = "inline-block";
        }
    </script>
</body>
</html>
