<?php include 'includes/header.php'; ?>
<style>
    /* Estilo para botões verdes */
    .btn-green {
        background-color: #1cc88a; /* Cor de fundo verde */
        color: white; /* Cor do texto branco */
        padding: 10px 20px; /* Espaçamento interno */
        border: none; /* Sem borda */
        border-radius: 5px; /* Bordas arredondadas */
        cursor: pointer; /* Cursor de mão ao passar */
        text-decoration: none; /* Sem sublinhado */
    }

    /* Estilo para botões verdes ao passar o mouse */
    .btn-green:hover {
        background-color: #17A673; /* Cor de fundo mais escura */
    }

    /* Estilo para a tabela */
    table {
        width: 100%;
        border-collapse: collapse;
    }

    th, td {
        padding: 15px;
        text-align: left;
        border-bottom: 1px solid #ddd;
    }

    th {
        background-color: #f2f2f2;
        color: #333;
        font-weight: bold;
    }

    td {
        background-color: #fff;
        color: #555;
    }

    /* Estilo para linhas alternadas */
    tr:nth-child(even) {
        background-color: #f9f9f9;
    }

    /* Estilo para hover */
    tr:hover {
        background-color: #f5f5f5;
        transition: background-color 0.3s ease;
    }

    /* Estilo para botões de ação */
    .action-buttons button {
        padding: 8px 12px;
        margin-right: 5px;
        border: none;
        border-radius: 4px;
        cursor: pointer;
        transition: background-color 0.3s ease;
    }

    .action-buttons button.edit {
        background-color: #3498db;
        color: #fff;
    }

    .action-buttons button.delete {
        background-color: #e74c3c;
        color: #fff;
    }

    .action-buttons button:hover {
        opacity: 0.8;
    }
</style>


<div class="col-lg-12">
    <!-- Códigos Personalizados -->
    <div class="card border-left-primary shadow h-100 card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary"><i class="fa fa-pencil-square-o" aria-hidden="true"></i> Gerenciar Banner</h6>
        </div>
        <div class="card-body">
            <button class="btn-green" onclick="showForm()">Adicionar Banner</button>

            <!-- Formulário de adicionar banner (inicialmente oculto) -->
            <div class="card-header py-3" id="bannerForm" style="display: none;">
<h1 class="h3 mb-1 text-gray-800">Adicionar Novo Banner</h1>                <form action="upload.php" method="post" enctype="multipart/form-data">
                    <label for="title">Título:</label>
                    <input type="text" name="title" id="title"><br>
                    <input type="file" name="banner" id="banner">
                    <input class="btn-green" type="submit" value="Enviar" name="submit">
                </form>
            </div>

            <h2>Banners Existentes</h2>
            <table border="1">
                <tr>
                    <th>Título</th>
                    <th>Imagem</th>
                    <th>Ações</th>
                </tr>
         <?php 
// Diretório onde os banners são armazenados
$directory = "uploads/";

// Verifica se o diretório de uploads existe e é acessível
if (is_dir($directory) && is_readable($directory)) {
    // Obtém todos os arquivos de imagem no diretório de uploads
    $banner_files = glob($directory . "*.{jpg,jpeg,png,gif}", GLOB_BRACE);

    // Exibe os banners na tabela
    foreach ($banner_files as $file) {
        $filename = pathinfo($file, PATHINFO_FILENAME);
        echo "<tr>";
        echo "<td>$filename</td>"; // Exibir o título do banner
        echo "<td><img src='$file' alt='$filename' width='100'></td>";
        echo "<td>";
        // Botão para editar com estilo verde
        echo "<button class='btn-green' onclick='showEditForm(\"$filename\", \"$filename\")'>Editar</button>"; 
        // Botão para excluir com estilo verde
        echo "<button class='btn-green' onclick='confirmDelete(\"$filename\")'>Excluir</button>"; 
        echo "</td>";
        echo "</tr>";
    }
} else {
    echo "<tr><td colspan='3'>O diretório de uploads não existe ou não é acessível.</td></tr>";
}
?>

            </table>

            <!-- Formulário de edição de banner (inicialmente oculto) -->
            <div class="card-header py-3" id="editBannerForm" style="display: none;">
                <h2>Editar Banner</h2>
                <form action="edit.php" method="post" enctype="multipart/form-data">
                    <label for="editTitle">Novo Título:</label>
                    <input type="text" name="editTitle" id="editTitle"><br>
                    Selecione a nova imagem do banner:
                    <input type="file" name="editBanner" id="editBanner">
                    <!-- Campo oculto para o novo título -->
                    <input type="hidden" name="newTitle" id="newTitle">
                    <input type="submit" value="Salvar" name="submit">
                </form>
            </div>

            <script>
                // Função para mostrar o formulário de adicionar banner
                function showForm() {
                    document.getElementById("bannerForm").style.display = "block";
                }

                // Função para mostrar o formulário de editar banner
                function showEditForm(filename, title) {
                    // Preencher o campo de título do formulário de edição
                    document.getElementById("editTitle").value = title;
                    // Preencher o campo oculto com o novo título
                    document.getElementById("newTitle").value = title;
                    // Exibir o formulário de edição
                    document.getElementById("editBannerForm").style.display = "block";
                }

                // Função para confirmar a exclusão do banner
                function confirmDelete(filename) {
                    if (confirm("Tem certeza que deseja excluir o banner '" + filename + "'?")) {
                        // Se confirmado, redirecionar para a mesma página com um parâmetro de exclusão
                        window.location.href = "fundo.php?delete=" + filename;
                    }
                }
            </script>

            <?php
            // Lógica para exclusão do banner
            if (isset($_GET['delete'])) {
                $filename = $_GET['delete'];
                $filepath = $directory . $filename . '.jpg'; // Você pode alterar a extensão conforme necessário
                if (file_exists($filepath)) {
                    unlink($filepath);
                    echo "<script>alert('Banner $filename excluído com sucesso.');</script>";
                    echo "<meta http-equiv='refresh' content='0'>"; // Atualiza a página após a exclusão
                    exit; // Impede a execução do restante do código PHP
                }
            }
            ?>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
