<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Seleção de Opção</title>
  <!-- Adicionando Bootstrap CSS -->
  <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
  <!-- Adicionando CSS personalizado -->
  <style>
    body {
      background-color: #f8f9fa;
      position: relative;
    }
    .container {
      margin-top: 50px;
    }
    .card {
      border: none;
      border-radius: 10px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    }
    .card-header {
      background-color: #007bff;
      color: #fff;
      border-radius: 10px 10px 0 0;
    }
    .btn-primary {
      background-color: #007bff;
      border-color: #007bff;
    }
    .btn-primary:hover {
      background-color: #0056b3;
      border-color: #0056b3;
    }
    .logo {
      position: absolute;
      top: 20px;
      left: 50%;
      transform: translateX(-50%);
      width: 100px;
      height: auto;
    }
    .content {
      display: none;
    }
    .show-content .content {
      display: block;
    }
  </style>
</head>
<body>

<!-- Adicionando imagem centralizada na parte superior -->
<img src="logo.png" alt="Logo" class="logo">

<div class="container">
  <div class="row justify-content-center">
    <div class="col-md-6">
      <div class="card">
        <div class="card-header">
          <h2 class="text-center">Selecione uma opção:</h2>
        </div>
        <div class="card-body">
          <select class="form-control mb-3" id="opcoes">
            <option value="autoads.php">Automático</option>
            <option value="autoads2.php">Automático 2</option>
            <option value="menads.php">Manual</option>
          </select>
          <button class="btn btn-primary btn-block" onclick="salvarOpcao()">Salvar</button>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Adicionando Bootstrap JS -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>

<script>
  function salvarOpcao() {
    var opcaoSelecionada = document.getElementById("opcoes").value;
    $.ajax({
        url: 'opcao.php',
        method: 'POST',
        data: {opcao: opcaoSelecionada},
        success: function(response) {
            alert('Opção salva com sucesso!');
        }
    });
  }
</script>

</body>
</html>
